local t = Def.ActorFrame {};

local function GetEdits( in_Song, in_StepsType )
	if in_Song then
		local sSong = in_Song;
		local sCurrentStyle = GAMESTATE:GetCurrentStyle();
		local sStepsType = in_StepsType;
		local iNumEdits = 0;
		if sSong:HasEdits( sStepsType ) then
			local tAllSteps = sSong:GetAllSteps();
			for i,Step in pairs(tAllSteps) do
				if Step:IsAnEdit() and Step:GetStepsType() == sStepsType then
					iNumEdits = iNumEdits + 1;
				end
			end
			return iNumEdits;
		else
			return iNumEdits;
		end
	else
		return 0;
	end
end;

t[#t+1] = Def.ActorFrame {
	Def.Quad{ InitCommand=cmd(halign,0;zoomto,44,16;diffuse,CustomDifficultyToColor("Difficulty_Beginner");zwrite,true;ztest,true); },
	Def.Quad{ InitCommand=cmd(draworder,-1;rotationz,20;zoomto,6,24;diffuse,color("#000000");zwrite,true;blend,'BlendMode_NoEffect'); },
	Def.Quad{ InitCommand=cmd(draworder,-1;x,44;rotationz,20;zoomto,6,24;diffuse,color("#000000");zwrite,true;blend,'BlendMode_NoEffect'); },
};
t[#t+1] = Def.ActorFrame {
	Def.Quad{ InitCommand=cmd(halign,0;x,44;zoomto,44,16;diffuse,CustomDifficultyToColor("Difficulty_Easy");zwrite,true;ztest,true); },
	Def.Quad{ InitCommand=cmd(draworder,-1;x,44*2;rotationz,20;zoomto,6,24;diffuse,color("#000000");zwrite,true;blend,'BlendMode_NoEffect'); },
};
t[#t+1] = Def.ActorFrame {
	Def.Quad{ InitCommand=cmd(halign,0;x,44*2;zoomto,44,16;diffuse,CustomDifficultyToColor("Difficulty_Medium");zwrite,true;ztest,true); },
	Def.Quad{ InitCommand=cmd(draworder,-1;x,44*3;rotationz,20;zoomto,6,24;diffuse,color("#000000");zwrite,true;blend,'BlendMode_NoEffect'); },
};
t[#t+1] = Def.ActorFrame {
	Def.Quad{ InitCommand=cmd(halign,0;x,44*3;zoomto,44,16;diffuse,CustomDifficultyToColor("Difficulty_Hard");zwrite,true;ztest,true); },
	Def.Quad{ InitCommand=cmd(draworder,-1;x,44*4;rotationz,20;zoomto,6,24;diffuse,color("#000000");zwrite,true;blend,'BlendMode_NoEffect'); },
};
t[#t+1] = Def.ActorFrame {
	Def.Quad{ InitCommand=cmd(halign,0;x,44*4;zoomto,44,16;diffuse,CustomDifficultyToColor("Difficulty_Challenge");zwrite,true;ztest,true); },
	Def.Quad{ InitCommand=cmd(draworder,-1;x,44*5;rotationz,20;zoomto,6,24;diffuse,color("#000000");zwrite,true;blend,'BlendMode_NoEffect'); },
};

for idx,diff in pairs(Difficulty) do
	local sDifficulty = ToEnumShortString( diff );
	local tLocation = {
		Beginner	= 8,
		Easy 		= 8+44,
		Medium		= 8+44*2,
		Hard		= 8+44*3,
		Challenge	= 8+44*4,
		Edit 		= 16+32*5.6,
	};
	t[#t+1] = Def.ActorFrame {
		OnCommand=function(self)
			local c = self:GetChildren();
			local song = GAMESTATE:GetCurrentSong()
			local bHasStepsTypeAndDifficulty = false;
			local meter = ""
			if song then
				local st = GAMESTATE:GetCurrentStyle():GetStepsType()
				bHasStepsTypeAndDifficulty = song:HasStepsTypeAndDifficulty( st, diff );
				local steps = song:GetOneSteps( st, diff );
				if steps then
					local newMeter = string.match(steps:GetDescription(),"%([%d]+.%d%)")
					if newMeter then
						if GetCurrentSong() then
							meter = string.format("%.1f",(newMeter:gsub("%(",""):gsub("%)","")) * RateModUpdateFunction())
						end
					else
						if GetCurrentSong() then
							meter = string.format("%.1f",steps:GetMeter() * RateModUpdateFunction())
						end
					end
					
					append = ""
					if diff == 'Difficulty_Edit' then
						meter = ""
					end
				end
			end
			c.Meter:settext(meter);
			self:playcommand(bHasStepsTypeAndDifficulty and "Show" or "Hide");
		end;
		
		CurrentSongChangedMessageCommand=cmd(playcommand,"On");
		RateModChangedMessageCommand=cmd(playcommand,"On");
		
		LoadFont("StepsDisplay","Meter") .. {
			Name="Meter";
			ShowCommand=cmd(stoptweening;linear,0.1;diffuse,Black());
			InitCommand=cmd(x,tLocation[sDifficulty]+14;zoom,0.45;diffuse,Black());
		};
	};
end

return t